import 'package:flutter/material.dart';
import 'package:flutter_riverpod/legacy.dart';
import '../models/article.dart';

import '../services/wordpress_service.dart';

class LatestArticlesBloc extends ChangeNotifier {
  int _page = 1;
  int get page => _page;

  final List<Article> _articles = [];
  List<Article> get articles => _articles;

  bool _loading = false;
  bool get loading => _loading;

  final int _postAmountPerLoad = 10;

  Future<void> fetchData(List<int> blockedCategoryIds) async {
    await WordPressService().fetchAllPosts(_page, _postAmountPerLoad, blockedCategoryIds).then((value) {
      _articles.addAll(value);
      notifyListeners();
    });
  }

  void setLoading(bool value) {
    _loading = value;
    notifyListeners();
  }

  void pageIncreament() {
    _page += 1;
    notifyListeners();
  }

  Future<void> onReload(List<int> blockedCategoryIds) async {
    _articles.clear();
    _page = 1;
    notifyListeners();
    fetchData(blockedCategoryIds);
  }
}

final latestArticlesBlocProvider = ChangeNotifierProvider<LatestArticlesBloc>((ref) {
  return LatestArticlesBloc();
});
